function main()
{
  var app = System.GetInterface('Application');
  var Model = app.Models.GetObject(0);
  //The parameter in GetObject determines here with which model the script should work.
  //0 is the first model listed in the Application View.
  //1 is the second model listed in the Application Viewa
  //etc.
  var Entity, Attribute, e, a;

  var DataType_Varchar2 = Model.ModelDef.DataTypes.GetObjectByName("Varchar2(%p1 %p2)");
  if (DataType_Varchar2 == null)
    return;

  Model.Lock();
  for (e=0; e<Model.Entities.Count; e++)
  {
    Entity = Model.Entities.GetObject(e);
    Entity.Lock();
    for (a=0; a<Entity.Attributes.Count; a++)
    {
      Attribute = Entity.Attributes.GetObject(a);
      if (Attribute.DataType != null)
        if (Attribute.DataType.Name == "Char(%p1 %p2)")
        {
          Attribute.SetLinkedObject("DataType", DataType_Varchar2);
          Attribute.DataTypeParam2 = "";
          Log.Information("Attribute "+Attribute.Name+" in entity "+Entity.Name+" changed.");
        }
    }
    Entity.UnLock();
  }
  Model.UnLock();
}