
//----------------------------------------------------------
// Alarm table widget
//----------------------------------------------------------

var max_alarms_displayed = 20;
var available_alarms = [
            "ALM01 - Power line failure",
            "ALM02 - Drive communication loss",
            "ALM03 - Emergency gate OPEN",
            "ALM04 - Misaligment sprayers",
            "ALM05 - Axis control failure",
            "ALM06 - RED tank empty",
            "ALM07 - GREEN tank empty",
            "ALM08 - BLUE tank empty",
            "ALM09 - Air compressor fault",
            "ALM10 - Replace NABA filters",
            "ALM11 - General failure, system block",
            "ALM12 - Motor 1 failure",
            "ALM13 - Motor 2 failure",
            "ALM14 - Motor 3 falure"
        ];

project.model = [];
project.add_new_alarm = function(){
    
    var row_definition = {
        _h : [
              [["text"]]
              ]  
       } 
    
    var row_data = {
        _t : 0,
        _v : [available_alarms[Math.round((available_alarms.length-1)*Math.random())]]
    }
    
    var max_row;
    if (project.model.length == 0){
        project.model = [];                                   
        project.model[0] = row_definition;
        project.model[1] = row_data;
    }
    else{
        if (project.model.length > max_alarms_displayed){
            max_row = max_alarms_displayed;
        }
        else{
            max_row = project.model.length;
        }

        for (var r = max_row; r > 1; r--){
            project.model[r] = project.model[r-1];                                       
        }
        project.model[1] = row_data;
                                   
    }

}


