

//----------------------------------------------------------
// Cars Rotation
//----------------------------------------------------------
var alarm;
var slow_flag = 0;
var rotate = true;
var rotation_clock;
var rotation_anticlock;
var rotation_running;
var Timer_paint;
var Timer_rfid_up;
var Timer_rfid_down;
var cars;
var step = 6;
var Timer_rotation = page.setInterval("rotation_simulation()", 80);     // fast speed = value (80ms), slow speed = value x 4 (80x4=320ms)


function stopRfid_up(){
    project.setTag("rfid_reader_up",0);
    project.setTag("rfid_reader_up_alarm",0);
    page.clearTimeout(Timer_rfid_up);
}

function stopRfid_down(){
    project.setTag("rfid_reader_down",0);
    project.setTag("rfid_reader_down_alarm",0);
    page.clearTimeout(Timer_rfid_down);
}


function PaintCar(){
    rotate = true;
    page.clearTimeout(Timer_paint);
}


function rotation_simulation()
{

    if (rotate == true)
    {
        cars = page.getWidget("cars");
    
        if (project.getTag("rotation_running",0))
        {
            
            page.getWidget("stop_sign").setProperty("visibility",1);
            alarm = 0;
   
            if (project.getTag("speed_slow",0) == 1){
                slow_flag++;
                if (slow_flag == 4){
                    slow_flag = 0;
                } 
                else 
                {
                    return;
                }
            }
            
            if(project.getTag("rotation_clockwise",0))
            {
                if (cars.rotation>=(360-step))
                {
                    cars.rotation = 0;
                }
                else
                {
                    cars.rotation = cars.rotation+step;            
                }
            }
    
            if(project.getTag("rotation_anticlockwise",0))
            {
                if (cars.rotation<=step)
                {
                    cars.rotation = 360;            
                }
                else
                {
                    cars.rotation = cars.rotation-step;                                
                }         
            }
                         
   
            switch(cars.rotation)
            {
                // stop for some seconds for painting
                case 0:
                case 114:
                case 252:
                    rotate = false;
                    page.getWidget("stop_sign").setProperty("visibility",0);
                    Timer_paint = page.setTimeout("PaintCar()", 5000);                      
                    break;
                
                // write on rfid tags when car pass near rfid reader "down"
                case 24:
                case 144:
                case 264:
                    project.setTag("rfid_reader_down",1);
                    alarm = Math.round(Math.random());
                    project.setTag("rfid_reader_down_alarm", alarm);
                    if (alarm) project.add_new_alarm();
                    project.setTag("id_down2",project.getTag("id_down1",0));
                    project.setTag("id_down1",254*Math.random());  
                    project.setTag("msg",project.getTag("msg",0)+1);
                    Timer_rfid_down = page.setTimeout("stopRfid_down()", 3000);
                    update_alarm_table();  
                    break;
                    
                // write on rfid tags when car pass near rfid reader "up"
                case 78:
                case 222:
                case 300:                        
                    project.setTag("rfid_reader_up",1);
                    alarm = Math.round(Math.random());
                    project.setTag("rfid_reader_up_alarm", alarm);
                    if (alarm) project.add_new_alarm();
                    project.setTag("id_up2",project.getTag("id_up1",0));
                    project.setTag("id_up1",254*Math.random());  
                    project.setTag("msg",project.getTag("msg",0)+1);
                    Timer_rfid_up = page.setTimeout("stopRfid_up()", 3000);                      
                    update_alarm_table();  
                    break;
                 
            }          
            if (project.getTag("msg",0) == 6) project.setTag("msg",0);
        }
    }
}



//----------------------------------------------------------
// Alarm table widget
//----------------------------------------------------------

function update_alarm_table(){
    var tableWgt = page.getWidget("alarm_panel");    
    if (project.model != "") tableWgt.model = project.model;    
}





