
//----------------------------------------------------------
// Color selection
//----------------------------------------------------------

var iTouchX;
var iTouchY;
var wgt = page.getWidget('imgColorWheel');

function RGB16String(RGB16)
{
    var Color =  "rgb(" + ((RGB16 & 0xF800) >> 8) + "," + ((RGB16 & 0x07E0) >> 3) + "," + ((RGB16 & 0x001F) << 3) + ")";
    return Color;
}

function rgb() {
    var Xpos = ((iTouchX - wgt.x) / wgt.width) * 2.0 - 1.0;
    var Ypos = ((iTouchY - wgt.y) / wgt.height) * 2.0 - 1.0;
    var Radius = Math.sqrt((Xpos * Xpos) + (Ypos * Ypos));
    var R, G, B;			// Base colors
    
    if (Radius <= 1.00)	// Press within wheel ?
    {
        // Calculate angle in degrees
        var Angle = Math.atan(Ypos / Xpos) * 180.0 / Math.PI + 90.0;
        if (Xpos < 0.0)
            Angle += 180.0;
        
        var AngleRemains = Angle % 60.0;
        var AngleSection = (Angle - AngleRemains) / 60;
        
        // Calculate base color dependent of angle
        switch (AngleSection)
        {
        case 0:	// 0 - 60 degrees
            R = 255;
            G = Math.round(AngleRemains * 4.25);
            B = 0;
            break;
            
        case 1:	// 60 - 120 degrees
            R = Math.round(255 - (AngleRemains * 4.25));			
            G = 255;
            B = 0;
            break;
            
        case 2:	// 120 - 180 degrees
            R = 0;			
            G = 255;
            B = Math.round(AngleRemains * 4.25);
            break;
            
        case 3:	// 180 - 240 degrees
            R = 0;			
            G = Math.round(255 - (AngleRemains * 4.25));
            B = 255;
            break;
            
        case 4:	// 240 - 300 degrees
            R = Math.round(AngleRemains * 4.25);			
            G = 0;
            B = 255;
            break;
            
        case 5:	// 300 - 360 degrees
            R = 255;			
            G = 0;
            B = Math.round(255 - (AngleRemains * 4.25));
            break;
        }
        
        // Brightness adjustment
        var BR = Math.round((255 - R) * Radius);
        var BG = Math.round((255 - G) * Radius);
        var BB = Math.round((255 - B) * Radius);
        
        R = 255 - BR;			
        G = 255 - BG;			
        B = 255 - BB;			
        
        var RGB16 = ((R & 0xF8) << 8) + ((G & 0xFC) << 3) + (B >> 3);
        project.setTag('colorRGB', RGB16String(RGB16));
        project.setTag ('R', R);
        project.setTag ('G', G);
        project.setTag ('B', B);
    }
}

function pageXupdate(me, eventInfo)
{
    iTouchX = eventInfo.newValue;
    rgb(); 
}

function pageYupdate(me, eventInfo)
{
    iTouchY = eventInfo.newValue;
    rgb(); 
}


//----------------------------------------------------------
// Chassis selection
//----------------------------------------------------------

var chassis = page.getWidget("chassis_group");
var x_big = chassis.getProperty("x");
var y_big = chassis.getProperty("y");
var width_big = chassis.getProperty("width");
var height_big = chassis.getProperty("height");        
var middleX = x_big + width_big/2;
var middleY = y_big + height_big/2;
var width_small = width_big/2.5;
var height_small = height_big/2.5;
var x_small = x_big + (width_big - width_small)/2;
var y_small = y_big + (height_big - height_small)/2;

function prevChassis(me, eventInfo)
{
    var state = new State();
    var cha =  project.getTag("chassis", state);
    if (cha>0){
        project.setTag("chassis", cha-1);
    }  
    else {
        project.setTag("chassis", 2);
    }  
}

function nextChassis(me, eventInfo)
{
      var state = new State();
      var cha =  project.getTag("chassis", state);
      if (cha<2){
          project.setTag("chassis", cha+1);
      }  
      else {
          project.setTag("chassis", 0);
      }
}

function zoomImg(me, eventInfo)
{
    var dx = eventInfo.dx;
    var dy = eventInfo.dy;
    if (dx<0 && dy<0) {
        if (chassis.x <= x_small && chassis.width >= width_small){
            if (chassis.y <= y_small && chassis.height >= height_small) {
                chassis.width= (chassis.width+(dx/4));
                chassis.height= ((chassis.width*height_big)/width_big);
                chassis.x=(middleX-chassis.width/2);
                chassis.y=(middleY-chassis.height/2);
                return;
            }
            else {
                return;
            }            
        }
        else {
            return;
        }        
    }
    else {
        if (chassis.x >= x_big && chassis.width <= width_big){
            if (chassis.y >= y_big && chassis.height <= height_big) {
                chassis.width= (chassis.width+(dx/4));
                chassis.height= ((chassis.width*height_big)/width_big);
                chassis.x=(middleX-chassis.width/2);
                chassis.y=(middleY-chassis.height/2);                
            return;
            }
            else {
                return;
            }            
        }
        else {
            return;
        }
    }  
}

function changeChassis(me, eventInfo)
{
    var move = eventInfo.dx;
    if (eventInfo.running) return;
    if (move<0){
        nextChassis ();
    }
    else {
        prevChassis ();
    }
}

function Page2_onActivate(me, eventInfo)
{
    chassis.x = x_small;
    chassis.y = y_small;
    chassis.width = width_small;
    chassis.height = height_small;
    
}

//----------------------------------------------------------
// Alarm table widget
//----------------------------------------------------------

var tableWgt = page.getWidget("alarm_panel");    
if (project.model != "") tableWgt.model = project.model;  